/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.event.ConsoleDataEvent;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.attention.CommonProblemAttention;
import com.ibm.hwmca.xfw.pa.problem.JournaledProblem;
import java.io.File;
import java.io.FileWriter;

public class CriticalProblem
extends JournaledProblem
implements Persistable {
    private static final String TRACE_MASKT = "XPACRITT";
    private static final String TRACE_MASKF = "XPACRITF";
    private static final String TRACE_MASKD = "XPACRITD";
    private static final boolean UNIT_TEST = true;

    public CriticalProblem() {
        this("Critical Problem");
        Trace.trace(TRACE_MASKD, "<--> CriticalProblem.ctor()");
        this.setPrimaryDataEvent(new ConsoleDataEvent(this));
    }

    public CriticalProblem(String description) {
        super(description);
        ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        this.setPrimaryAnalyzingConsoleSystem(cad.getConsoleSystem());
        this.setFailingSystem(cad.getConsoleSystem());
        this.setPrimaryDataEvent(new ConsoleDataEvent(this));
    }

    public CriticalProblem(PersistentData data) throws PersistenceException {
        super(((CriticalProblemPersistentData)data).superClassPersistentData);
    }

    public CriticalProblem(String refcode, String extension) {
        this();
        Trace.trace(TRACE_MASKD, "-->CriticalProblem.ctor()");
        this.setRefcode(refcode);
        this.setExtension(extension);
        this.setProblemType("2");
        this.addProblemStatement((LocalizableText)new BaseMessageText("XPA23000"));
        this.addProblemStatement((LocalizableText)new BaseMessageText("XPA3002"));
        Trace.trace(TRACE_MASKD, "<--- CriticalProblem.ctor()");
    }

    public CriticalProblem(String refcode, String extension, String secondaryRefcode, String secondaryExtension) {
        this(refcode, extension);
        Trace.trace(TRACE_MASKF, "-->CriticalProblem (" + refcode + " " + extension + " " + secondaryRefcode + " " + secondaryExtension + ")");
        this.setSecondaryRefcode(secondaryRefcode);
        this.setSecondaryExtension(secondaryExtension);
        Trace.trace(TRACE_MASKF, "<--CriticalProblem");
    }

    public PersistentData getPersistentData() {
        CriticalProblemPersistentData persistentData = new CriticalProblemPersistentData();
        persistentData.superClassPersistentData = super.getPersistentData();
        return persistentData;
    }

    public final void open() {
        Trace.trace(TRACE_MASKD, "CriticalProblem.open()");
    }

    public void postIt() {
        Trace.trace(TRACE_MASKT, "---> POSTING CRITICAL ERROR");
        try {
            this.getCustomerInfo();
            this.getServiceInfo();
            this.getRSFInfo();
            Trace.trace(TRACE_MASKD, "give it to the problem manager");
            ProblemManager.getProblemManager().open(this);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception on ProblemManager.get()");
            Trace.trace(TRACE_MASKD, e);
            this.postFootPrint("AA32DEAD");
        }
        try {
            HMC hmc = HMC.getHMC();
            CommonProblemAttention anAttention = new CommonProblemAttention(hmc.getObjectId(), new BaseMessageText("XPA23000"));
            anAttention.setProblem(this);
            hmc.addAttention(anAttention);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception on posting attention");
            Trace.trace(TRACE_MASKD, e);
            this.postCrash("AA32DEAC");
        }
        Trace.trace(TRACE_MASKT, "<--- POSTING CRITICAL ERROR");
    }

    private void postFootPrint(String refcode) {
        Trace.trace(TRACE_MASKD, "-->Post footprint");
        try {
            String path = BaseFileControl.getFilePath("pacrashdir");
            File file = new File(path);
            file.mkdir();
            FileWriter fw = new FileWriter(path + "footprint.pa." + this.getRefcode() + "." + this.getExtension() + "." + System.currentTimeMillis());
            fw.write(refcode);
            fw.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "exception");
            Trace.trace(TRACE_MASKD, e);
            this.postCrash("AA32DEAB");
        }
        Trace.trace(TRACE_MASKD, "<-- Post footprint");
    }

    private void postCrash(String refcode) {
        Trace.trace(TRACE_MASKD, "-->Post Crash");
        try {
            String path = BaseFileControl.getFilePath("pacrashdir");
            File file = new File(path);
            file.mkdir();
            FileWriter fw = new FileWriter(path + "crash.pa." + refcode + "." + System.currentTimeMillis());
            fw.write(this.toString());
            fw.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "got an exception");
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKD, "<--Post Crash");
    }

    private static class CriticalProblemPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public PersistentData superClassPersistentData = null;
        public int version = 1;

        private CriticalProblemPersistentData() {
        }
    }
}

